<?php
// Conexión a la base de datos
$host = 'localhost';
$dbname = 'yoveraes_botica';
$username = 'root';         //'yoveraes_userdb';
$password = '';             //'t7@s5FxYn1GB';

try {
    $conn = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo "Error de conexión: " . $e->getMessage();
    exit();
}
date_default_timezone_set('America/Lima');
?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Pedidos Diaria</title>
    <script src="/Botica/views/ventas/js/jquery.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css"
        integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
    <script language="javascript" src="/Botica/views/ventas/js/jquery-3.1.1.min.js"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script language="javascript"></script>
    <style>
        /* Estilos personalizados para el botón */
        .boton-personalizado {
            background-color: #4CAF50;
            /* Verde */
            border: none;
            color: white;
            padding: 15px 32px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 18px;
            margin: 4px 2px;
            cursor: pointer;
            border-radius: 12px;
        }

        .boton-personalizado:hover {
            background-color: #45a049;
            /* Verde más oscuro */
        }
    </style>
    <style>
        /* Estilos básicos */
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }

        .container {
            max-width: 1000px;
            margin: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            padding: 10px;
            border: 1px solid #ccc;
            text-align: center;
        }

        button {
            padding: 5px 10px;
            color: #fff;
            background: #e74c3c;
            border: none;
            cursor: pointer;
        }

        button:hover {
            background: #c0392b;
        }
    </style>
    <style>
        /* Estilo para reducir la fuente */
        .tabla-pequena {
            font-size: 14px;
            /* Ajusta el tamaño de la fuente */
            border-collapse: collapse;
            width: 100%;
        }

        .tabla-pequena th,
        .tabla-pequena td {
            border: 1px solid #ddd;
            padding: 8px;
        }

        .tabla-pequena th {
            background-color: #3e64d3;
            text-align: left;
        }
    </style>
    <script>
        // Función para sumar los valores de la columna de montos
        function sumarMontos() {
            let total = 0;
            let montos = document.querySelectorAll('.total'); // Seleccionamos todos los elementos con la clase 'monto'
            montos.forEach(function (element) {
                total += parseFloat(element.innerText) || 0;  // Sumamos el contenido de cada elemento
            });
            // Mostrar el total en el campo de texto con id "totalMonto"
            document.getElementById('totalMonto').value = total.toFixed(2);
        }
    </script>
</head>
<h2 class="subtitle"><i class="fas fa-clipboard-check"></i> &nbsp;Pedidos | Ventas Diarias
</h2>

<body onload="cargarVentas()">
    <div class="table-responsive">
        <h2>Reporte de Ventas Diaria</h2>

        <label for="fecha">Seleccione la fecha:</label>
        <input type="date" id="fecha" value="<?php date_default_timezone_set('America/Lima');
        echo date('Y-m-d'); ?>" onchange="obtenerVentas()">

        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<button
            class="btn-success  btn-sm" onclick="imprimirPDF()"><i class="fas fa-file-pdf"></i>&nbsp;&nbsp;Imprimir
            Reporte</button>

        <table class="table table-striped table-hover tabla-pequena" style="width: 100%;">
            <thead class="table-dark table-bordered">
                <tr>
                    <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;" scope="col">Id.</th>
                    <th style="display:none; cursor:pointer;color:rgb(255,255,255);text-align:center;" scope="col">Item.
                    </th>
                    <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;" scope="col">Fecha Pedido</th>
                    <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;" scope="col">Documento</th>
                    <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;" scope="col">Hora Pedido</th>
                    <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;" scope="col">Cliente</th>
                    <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;" scope="col">Forma Pago</th>
                    <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;" scope="col">Total</th>
                    <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;" scope="col"></th>
                    <th style="cursor:pointer;color:rgb(255,255,255);text-align:center;" scope="col"></th>
                </tr>
            </thead>
            <tbody id="tablaVentas">
                <!-- Ventas cargadas dinámicamente aquí -->
            </tbody>
        </table>
    </div>

    <script>
        async function obtenerVentas() {
            const fecha = document.getElementById('fecha').value;
            const respuesta = await fetch(`/Botica/views/ventas/reporte_caja.php?fecha=${fecha}`);
            const ventas = await respuesta.json();
            let html = '';
            let id_correlativo = 1; // Inicializa el ID en 1
            ventas.forEach(venta => {
                html += `
                    <tr>
                        <td style="cursor:pointer;color:rgb(0,0,0);text-align:center;font-size:13px;">${id_correlativo}</td>
                        <td style="display:none; cursor:pointer;color:rgb(0,0,0);text-align:center;font-size:13px;">${venta.id}</td>
                        <td style="cursor:pointer;color:rgb(0,0,0);text-align:center;font-size:13px;">${venta.fecha}</td>
                        <td style="cursor:pointer;color:rgb(0,0,0);text-align:center;font-size:13px;">${venta.num_docpe}</td>
                        <td style="cursor:pointer;color:rgb(46,82,135);text-align:center;font-size:13px;font-weight-bold;">${venta.hora_vtap}</td>
                        <td style="cursor:pointer;color:rgb(0,0,0);text-align:left;font-size:13px;">${venta.cliente}</td>
                        <td style="cursor:pointer;color:rgb(0,0,0);text-align:center;font-size:12px;">${venta.metodo}</td>
                        <td style="cursor:pointer;color:rgb(0,0,0);text-align:right;font-size:13px;">${venta.total}</td>
                        <td><button onclick="eliminarVenta(${venta.id})"><i class="fas fa-trash-alt"></i> Eliminar</button></td>
                        <td><button class="btn-primary btn-sm" onclick="reimprimirPDF(${venta.id})"><i class="fas fa-file-pdf"></i>Imprimir</button></td>
                    </tr>
                `;
                id_correlativo++; // Incrementa el ID en cada iteración
            });
            document.getElementById('tablaVentas').innerHTML = html;
        }
        async function eliminarVenta(id) {
            if (confirm("¿Estás seguro de eliminar esta venta?")) {
                const respuesta = await fetch(`/Botica/views/ventas/reporte_caja.php`, {
                    method: 'DELETE',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded'
                    },
                    body: `id=${id}`
                });
                const resultado = await respuesta.json();
                if (resultado.success) {
                    obtenerVentas(); // Recargar la tabla
                } else {
                    alert("Error al eliminar la venta.");
                }
            }
        }

        function reimprimirPDF(id) {
            const url = `/Botica/views/ventas/reimprimir_fpdf.php?id=${id}`;
            window.open(url, '_blank');

            /*      fetch('/Botica/views/ventas/reimprimir_fpdf.php', {
                  method: 'POST',
                  headers: { 'Content-Type': 'application/json' },
                  body: JSON.stringify({ id: id })
              })
                  .then(response => {
                      if (response.ok) {
                          return response.blob(); // Recibe el PDF como un blob
                      } else {
                          throw new Error('Error al generar el PDF');
                      }
                  })
                  .then(blob => {
                      const url = window.URL.createObjectURL(blob);
                      const a = document.createElement('a');
                      a.href = url;
                      a.download = `ticket_${id}.pdf`;
                      document.body.appendChild(a);
                      a.click();
                      a.remove();
                  })
                  .catch(error => {
                      console.error('Error:', error);
                      alert('No se pudo reimprimir el ticket.');
                  });*/

        }

        // Cargar ventas del día actual al cargar la página
        window.onload = obtenerVentas();
    </script>

    <div class="form-container">
        <div class="card-body">
            <div class="row">
                <hr>
                <div class="col-md-7">
                    <label for="totalC" style="font-size:16px; color:rgb(25,54,93);height:10px;"><strong>Caja Diaria
                            Contado
                            (Hoy)</strong></label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    <input style="width: 80; font-size:16px; cursor:pointer;text-align: right;" type="text" id="totalC"
                        name="totalC" readonly>
                </div>
                <div class="col-md-7">
                    <label for="totalT" style="font-size:16px; color:rgb(25,54,93);height:10px;"><strong>Caja Diaria
                            Transferencia (Hoy)</strong></label>&nbsp;&nbsp;&nbsp;
                    <input style="width: 80; font-size:16px; cursor:pointer;text-align: right;" type="text" id="totalT"
                        name="totalT" readonly>
                </div>
                <div class="col-md-7">
                    <label for="totalY" style="font-size:16px; color:rgb(25,54,93);height:10px;"><strong>Caja Diaria
                            Yape
                            (Hoy)</strong></label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    <input style="width: 80; font-size:16px; cursor:pointer;text-align: right;" type="text" id="totalY"
                        name="totalY" readonly>
                </div>
                <div class="col-md-7">
                    <label for="totalP" style="font-size:16px; color:rgb(25,54,93);height:10px;"><strong>Caja Diaria
                            Plin
                            (Hoy)</strong></label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    <input style="width: 200; font-size:16px; cursor:pointer;text-align: right;" type="text" id="totalP"
                        name="totalP" readonly>
                </div>
                <div class="col-md-7">
                    <label for="totalO" style="font-size:16px; color:rgb(25,54,93);height:10px;"><strong>Caja Diaria
                            Otro
                            (Hoy)</strong></label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    <input style="width: 80; font-size:16px; cursor:pointer;text-align: right;" type="text" id="totalO"
                        name="totalO" readonly>
                </div>
                <hr>
                <div class="col-md-6">
                    <div class="input-group mb-5">
                        <label for="total" style="font-size:22px; color:rgb(25,54,93);"><strong>Caja Diaria
                                Total (Hoy)</strong></label>&nbsp;&nbsp;&nbsp;&nbsp;
                        <div class="input-group-prepend">
                            <span class="input-group-text"><i class="far fa-money-bill-alt"></i></span>
                            <input style="width: 110px; font-size:22px; cursor:pointer;text-align: right;" type="text"
                                id="total" name="total" readonly>
                        </div>
                    </div>
                    <hr>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            // Establecer la fecha actual en el input date
            let fechaInput = document.getElementById('fecha');
            let hoy = new Date();
            //hoy.setDate(hoy.getDate() - 1);
            let fechaActual = hoy.toISOString().split('T')[0]; // Formato YYYY-MM-DD
            fechaInput.value = fechaActual;

            // Cargar ventas al abrir la página
            cargarVentas();

            // También cargar datos cuando cambia la fecha
            fechaInput.addEventListener('change', cargarVentas);
        });

        function cargarVentas() {
            let fechaSeleccionada = document.getElementById('fecha').value;

            // Realizamos la petición AJAX con Fetch API
            fetch('/Botica/views/ventas/cargar_ventas.php?fecha=' + fechaSeleccionada)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('totalC').value = data.contado.toFixed(2);
                    document.getElementById('totalT').value = data.transferencia.toFixed(2);
                    document.getElementById('totalY').value = data.yape.toFixed(2);
                    document.getElementById('totalP').value = data.plin.toFixed(2);
                    document.getElementById('totalO').value = data.otro.toFixed(2);
                    document.getElementById('total').value = data.total.toFixed(2);
                })
                .catch(error => console.error('Error:', error));
        }
        /*    document.getElementById('fecha').addEventListener('change', function () {
                let fechaSeleccionada = this.value;
                // Realizamos la petición AJAX con Fetch API
                fetch('/Botica/views/ventas/cargar_ventas.php?fecha=' + fechaSeleccionada)
                    .then(response => response.json())
                    .then(data => {
                        document.getElementById('totalC').value = data.contado.toFixed(2);
                        document.getElementById('totalT').value = data.transferencia.toFixed(2);
                        document.getElementById('totalY').value = data.yape.toFixed(2);
                        document.getElementById('totalP').value = data.plin.toFixed(2);
                        document.getElementById('totalO').value = data.otro.toFixed(2);
                        document.getElementById('total').value = data.total.toFixed(2);
                    })
                    .catch(error => console.error('Error:', error));
            });*/
    </script>

    <script>
        function imprimirPDF() {
            let fechaSeleccionada = document.getElementById('fecha').value;
            window.open('/Botica/views/ventas/generar_reporte.php?fecha=' + fechaSeleccionada, '_blank');
        }
    </script>

</body>

</html>